/*
Just like Niagara, BajaScript has some Clock related functions...
*/

// Clock ticks (useful for profiling)
baja.outln("System ticks: " + baja.clock.ticks());

// Run a function asynchronously
baja.runAsync(function () {
  baja.outln("Running a function asynchronously");
});

baja.outln("Note how the async call above will invoke after this script has finished processing!");

var oneOffTimerFunc = function () {
  baja.outln("The one of timer has run!");
};

// Schedule a one off timer
var ticket = baja.clock.schedule(oneOffTimerFunc, 1000);

// Cancel the ticket
ticket.cancel();
baja.outln("Ticket expired: ");

// Schedule a one off timer!
ticket = baja.clock.schedule(oneOffTimerFunc, 1000);
baja.outln("Ticked expired (again): " + ticket.isExpired());

// Schedule a period timer
ticket = baja.clock.schedulePeriodically(function () {
  baja.outln("Periodic timer invoked");
}, 1500);

// Why not try changing the above code just for fun? If you get stuck just refresh the browser.
